<?php 
 
if(!function_exists('logiku_get_post_grid')){
    function logiku_get_post_grid($posts = [], $settings = []){ 
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
                logiku_get_post_grid_layout1($posts, $settings);
                break;

            case 'post-2':
                logiku_get_post_grid_layout2($posts, $settings);
                break;

            case 'post-3':
                logiku_get_post_grid_layout3($posts, $settings);
                break;

            case 'post-4':
                logiku_get_post_grid_layout4($posts, $settings);
                break;

            case 'post-5':
                logiku_get_post_grid_layout5($posts, $settings);
                break;

            case 'post-6':
                logiku_get_post_grid_layout6($posts, $settings);
                break;

            case 'portfolio-1':
                logiku_get_portfolio_grid_layout1($posts, $settings);
                break;

            case 'portfolio-2':
                logiku_get_portfolio_grid_layout2($posts, $settings);
                break;

            case 'portfolio-3':
                logiku_get_portfolio_grid_layout3($posts, $settings);
                break;

            case 'portfolio-4':
                logiku_get_portfolio_grid_layout4($posts, $settings);
                break;

            case 'service-1':
                logiku_get_service_grid_layout1($posts, $settings);
                break;

            case 'service-2':
                logiku_get_service_grid_layout2($posts, $settings);
                break;


            default:
                return false;
                break;
        }
    }
}

// Start Post Grid
//--------------------------------------------------
function logiku_get_post_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '427x344';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect2">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($post_video_link)) : ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post-content">
                        <div class="pxl-post--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                    </svg>
                                    <?php echo get_the_date('j M, Y'); ?>        
                                </div>
                            <?php endif; ?>
                            <div class="post-category">
                                <?php
                                $categories = get_the_category($post->ID);
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <h3 class="pxl-post--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-post btn-text-parallax" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <div class="btn-text">
                                        <?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('Read More', 'logiku');
                                        } ?>
                                    </div>
                                    <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                                </a>
                                <div class="pxl-admin">
                                    <?php if($show_author == 'true'): ?>
                                        <div class="pxl-post--author pxl-mr-10">
                                            <?php echo get_avatar($current_user->ID, 46, '', '', array('class' => 'pxl-mr-7')); ?>
                                            <?php echo esc_html__('By', 'logiku'); ?>&nbsp; <span>
                                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                    <?php echo esc_html(get_the_author()); ?>
                                                </a>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function logiku_get_post_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '685x484';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect2">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($post_video_link)) : ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post-content">
                        <div class="pxl-post--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                    </svg>
                                    <?php echo get_the_date('j M, Y', $post->ID); ?>        
                                </div>
                            <?php endif; ?>
                            <div class="post-category">
                                <?php
                                $categories = get_the_category($post->ID);
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <h3 class="pxl-post--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-post" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <div class="btn-text">
                                        <?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('Read More', 'logiku');
                                        } ?>
                                    </div>
                                    <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                                </a>
                                <div class="pxl-admin">
                                    <?php if($show_author == 'true'): ?>
                                        <div class="pxl-post--author pxl-mr-10">
                                            <?php echo get_avatar($current_user->ID, 46, '', '', array('class' => 'pxl-mr-7')); ?>
                                            <?php echo esc_html__('By', 'logiku'); ?>&nbsp; <span>
                                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                    <?php echo esc_html(get_the_author()); ?>
                                                </a>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function logiku_get_post_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '300x206';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="pxl-post-content">
                        <div class="pxl-post--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                    </svg>
                                    <?php echo get_the_date('j M, Y', $post->ID); ?>        
                                </div>
                            <?php endif; ?>
                            <div class="post-category">
                                <?php
                                $categories = get_the_category($post->ID);
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <h3 class="pxl-post--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-post btn-text-parallax" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <div class="btn-text">
                                        <?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('Read More', 'logiku');
                                        } ?>
                                    </div>
                                    <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                                </a>
                                <div class="pxl-admin">
                                    <?php if($show_author == 'true'): ?>
                                        <div class="pxl-post--author pxl-mr-10">
                                            <?php echo get_avatar($current_user->ID, 46, '', '', array('class' => 'pxl-mr-7')); ?>
                                            <?php echo esc_html__('By', 'logiku'); ?>&nbsp; <span>
                                                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                    <?php echo esc_html(get_the_author()); ?>
                                                </a>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect2">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($post_video_link)) : ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

function logiku_get_post_grid_layout4($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '300x206';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect2">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($post_video_link)) : ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post-content">
                        <div class="pxl-post--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                        <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                    </svg>
                                    <?php echo get_the_date('j M, Y', $post->ID); ?>        
                                </div>
                            <?php endif; ?>
                            <div class="post-category">
                                <?php
                                $categories = get_the_category($post->ID);
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        <h3 class="pxl-post--title title-hover-line"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-post" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <div class="btn-text">
                                        <?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('Read More', 'logiku');
                                        } ?>
                                    </div>
                                    <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

function logiku_get_post_grid_layout5($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '447x400';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect2">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if(!empty($post_video_link)) : ?>
                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post-content">
                        <div class="pxl-post--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-post--date">
                                    <div class="post-date"><?php echo get_the_date('j', $post->ID); ?></div>      
                                    <div class="post-date-1"><?php echo get_the_date('M', $post->ID); ?></div>              
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="content-inner">
                            <h3 class="pxl-post--title title-hover-line"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                            <?php if($show_excerpt == 'true'): ?>
                                <div class="pxl-post--content">
                                    <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <div class="pxl-post--button">
                                    <a class="btn-post" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <div class="btn-text">
                                            <?php if(!empty($button_text)) {
                                                echo esc_attr($button_text);
                                            } else {
                                                echo esc_html__('Read More', 'logiku');
                                            } ?>
                                        </div>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                                            <path d="M11.8892 2.04687C11.915 1.55049 11.5336 1.12711 11.0373 1.10122L2.94825 0.679366C2.45187 0.653479 2.02848 1.03489 2.0026 1.53127C1.97671 2.02765 2.35812 2.45104 2.8545 2.47692L10.0447 2.85191L9.66975 10.0421C9.64386 10.5385 10.0253 10.9619 10.5217 10.9878C11.018 11.0137 11.4414 10.6323 11.4673 10.1359L11.8892 2.04687ZM1 11L1.60239 11.6687L11.5928 2.66868L10.9904 2L10.388 1.33132L0.397612 10.3313L1 11Z" fill="#FA4729"/>
                                        </svg>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function logiku_get_post_grid_layout6($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '375x288';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = ''; 
            $current_user = wp_get_current_user();
            $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="inner-post">
                            <div class="pxl-post--featured hover-imge-effect2">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                <?php if(!empty($post_video_link)) : ?>
                                    <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                                <?php endif; ?>
                            </div>
                            <div class="pxl-post--meta">
                                <?php if($show_date == 'true'): ?>
                                    <div class="pxl-post--date">
                                        <div class="post-date"><?php echo get_the_date('j', $post->ID); ?></div>      
                                        <div class="post-date-1"><?php echo get_the_date('M', $post->ID); ?></div>              
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post-content">
                        <div class="content-inner">
                            <div class="post-category">
                                <?php
                                $categories = get_the_category($post->ID);
                                if (!empty($categories)) {
                                    foreach ($categories as $category) {
                                        echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                    }
                                }
                                ?>
                            </div>
                            <h3 class="pxl-post--title title-hover-line"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Post Grid
//--------------------------------------------------

// Start Portfolio Grid
//--------------------------------------------------
function logiku_get_portfolio_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '685x379';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID); 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <?php $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect3">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?>
                                <div class="pxl-post--holder">
                                    <div class="pxl-post--meta">
                                        <h5 class="pxl-post--title"><?php echo esc_html(get_the_title($post->ID)); ?></h5>
                                        <?php if($show_category == 'true'): ?>
                                            <div class="pxl-post--category">
                                                <?php the_terms( $post->ID, 'portfolio-category', '', ' / ' ); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach;
    endif;
}

function logiku_get_portfolio_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '553x668';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            $portfolio_excerpt = get_post_meta($post->ID, 'portfolio_excerpt', true);
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <?php $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        $gradient_from = logiku()->get_opt('gradient_color', ['from' => '#6000ff'])['from'];
                        $gradient_to = logiku()->get_opt('gradient_color', ['to' => '#fe0054'])['to'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect3">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="pxl-post--holder">
                            <h3 class="pxl-post--title title-hover-line">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                            </h3>
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-post--category">
                                    <?php the_terms( $post->ID, 'portfolio-category', '', '//' ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach;
    endif;
}
function logiku_get_portfolio_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : 'full';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            $portfolio_excerpt = get_post_meta($post->ID, 'portfolio_excerpt', true);
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <?php $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        $gradient_from = logiku()->get_opt('gradient_color', ['from' => '#6000ff'])['from'];
                        $gradient_to = logiku()->get_opt('gradient_color', ['to' => '#fe0054'])['to'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect3">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="pxl-post--holder">
                            <h3 class="pxl-post--title title-hover-line">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                            </h3>
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-post--category">
                                    <?php 
                                    $categories = get_the_terms($post->ID, 'portfolio-category');
                                    if ($categories && !is_wp_error($categories)) {
                                        $category = $categories[0];
                                        echo '<a href="' . esc_url(get_term_link($category)) . '">' . esc_html($category->name) . '</a>';
                                    }
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-post--button">
                                <a class="btn-post" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="76" height="76" viewBox="0 0 76 76" fill="none">
                                        <circle cx="38" cy="38" r="38" fill="#FA4729"/>
                                        <path d="M46.4764 31.0139C46.5052 30.4624 46.0815 29.9919 45.53 29.963L36.5423 29.4929C35.9907 29.464 35.5202 29.8877 35.4914 30.4393C35.4625 30.9908 35.8863 31.4613 36.4378 31.4901L44.4269 31.9081L44.0089 39.8971C43.9801 40.4487 44.4038 40.9192 44.9553 40.948C45.5069 40.9769 45.9774 40.5532 46.0062 40.0016L46.4764 31.0139ZM31 44L31.6692 44.7431L46.1469 31.7048L45.4777 30.9617L44.8085 30.2186L30.3308 43.2569L31 44Z" fill="white"/>
                                    </svg>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach;
    endif;
}
function logiku_get_portfolio_grid_layout4($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : 'full';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            $portfolio_excerpt = get_post_meta($post->ID, 'portfolio_excerpt', true);
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <?php $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        $gradient_from = logiku()->get_opt('gradient_color', ['from' => '#6000ff'])['from'];
                        $gradient_to = logiku()->get_opt('gradient_color', ['to' => '#fe0054'])['to'];
                        ?>
                        <div class="pxl-post--featured hover-imge-effect3">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="pxl-post--holder">
                            <div class="content-inner">
                                <?php if($show_category == 'true'): ?>
                                    <div class="pxl-post--category">
                                        <?php the_terms( $post->ID, 'portfolio-category', '', '-' ); ?>
                                    </div>
                                <?php endif; ?>
                                <h3 class="pxl-post--title">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach;
    endif;
}
// End Portfolio Grid
//--------------------------------------------------

// Start Service Grid
//--------------------------------------------------
function logiku_get_service_grid_layout1($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '447x322';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                <div class="pxl-post--icon pxl-fl-middle">
                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $service_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-post--icon pxl-fl-middle">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <a class="pxl-post--link" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"></a>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post--holder">
                        <h3 class="pxl-post--title">
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="pxl-excerpx">
                            <?php echo get_the_excerpt($post->ID);?>
                        </div>
                        <?php if($show_button == 'true') : ?>
                            <a class="pxl-post--readmore btn-text-parallax" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <div class="pxl-readmore-title"><?php echo esc_html__('Read More', 'logiku');//suncode ?></div>
                                <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach;
    endif;
}
function logiku_get_service_grid_layout2($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '447x322';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == 'col-66') {
                    $col_xl_m = '66-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == 'col-66') {
                    $col_lg_m = '66-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-post--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                        $img_id = get_post_thumbnail_id($post->ID);
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>
                        <div class="pxl-post--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                <div class="pxl-post--icon pxl-fl-middle">
                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $service_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-post--icon pxl-fl-middle">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <a class="pxl-post--link" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"></a>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-post--holder">
                        <h3 class="pxl-post--title">
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                        </h3>
                        <div class="pxl-excerpx">
                            <?php echo get_the_excerpt($post->ID);?>
                        </div>
                        <?php if($show_button == 'true') : ?>
                            <a class="pxl-post--readmore" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <div class="pxl-readmore-title"><?php echo esc_html__('Read More', 'logiku');//suncode ?></div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                                    <path d="M11.8892 2.04687C11.915 1.55049 11.5336 1.12711 11.0373 1.10122L2.94825 0.679366C2.45187 0.653479 2.02848 1.03489 2.0026 1.53127C1.97671 2.02765 2.35812 2.45104 2.8545 2.47692L10.0447 2.85191L9.66975 10.0421C9.64386 10.5385 10.0253 10.9619 10.5217 10.9878C11.018 11.0137 11.4414 10.6323 11.4673 10.1359L11.8892 2.04687ZM1 11L1.60239 11.6687L11.5928 2.66868L10.9904 2L10.388 1.33132L0.397612 10.3313L1 11Z" fill="#FA4729"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach;
    endif;
}
// End Service Grid
//-------------------------------------------------

// Start Product Grid
//--------------------------------------------------
// End Product Grid
//--------------------------------------------------

add_action( 'wp_ajax_logiku_load_more_post_grid', 'logiku_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_logiku_load_more_post_grid', 'logiku_load_more_post_grid' );
function logiku_load_more_post_grid(){
    if ( ! check_ajax_referer( '_ajax_nonce', 'wpnonce' ) || empty( sanitize_text_field( wp_unslash($_POST['wpnonce'] ))) ) {
        wp_send_json(
            array(
                'status' => false,
                'message' => esc_attr__('Nonce error, please reload.', 'logiku'),
                'data' => array(),
            )
        );
    }
    
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'logiku'));
        }
    
        $settings = isset($_POST['settings']) ? $_POST['settings'] : null;
       
        $source = isset($settings['source']) ? $settings['source'] : '';
        $term_slug = isset($settings['term_slug']) ? $settings['term_slug'] : '';
        if( !empty($term_slug) && $term_slug !='*'){
            $term_slug = str_replace('.', '', $term_slug);
            $source = [$term_slug.'|'.$settings['tax'][0]]; 
        }
        if( isset($_POST['handler_click']) && sanitize_text_field(wp_unslash( $_POST[ 'handler_click' ] )) == 'filter'){
            set_query_var('paged', 1);
            $settings['paged'] = 1;
        }else{
            set_query_var('paged', $settings['paged']);
        }
        extract(pxl_get_posts_of_grid($settings['post_type'], [
                'source' => $source,
                'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
                'order' => isset($settings['order'])?$settings['order']:'desc',
                'limit' => isset($settings['limit'])?$settings['limit']:'6',
                'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
                'post_not_in' => isset($settings['post_not_in'])?$settings['post_not_in']: [],
            ],
            $settings['tax']
        ));

        ob_start();
            logiku_get_post_grid($posts, $settings);
        $html = ob_get_clean();

        $pagin_html = '';
        if( isset($settings['pagination_type']) && $settings['pagination_type'] == 'pagination' ){ 
            ob_start();
                logiku()->page->get_pagination( $query,  true );
            $pagin_html = ob_get_clean();
        }
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'logiku'),
                'data' => array(
                    'html' => $html,
                    'pagin_html' => $pagin_html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}
 