<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '872x1024';
if(!empty($accordion)) : ?>
    <div class="pxl-accordion pxl-accordion4 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
     <?php if ($settings['style'] == 'style7') : ?>
        <h1 class="pxl-accordion--heading">
            <?php echo pxl_print_html($settings['title7']); ?>
        </h1>
    <?php endif; ?>
    <?php foreach ($accordion as $key => $value):
        $is_active = ($key + 1) == $active;
        $pxl_id = isset($value['_id']) ? $value['_id'] : '';
        $title = isset($value['title']) ? $value['title'] : '';
        $number = isset($value['number']) ? $value['number'] : '';
        $desc = isset($value['desc']) ? $value['desc'] : '';
        $image = isset($value['image']) ? $value['image'] : '';
        $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
        $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
        $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
        if ( ! empty( $value['link']['url'] ) ) {
            $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

            if ( $value['link']['is_external'] ) {
                $widget->add_render_attribute( $link_key, 'target', '_blank' );
            }

            if ( $value['link']['nofollow'] ) {
                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
            }
        }
        $link = isset($value['link']) ? $value['link'] : [];
        $widget->add_render_attribute( $icon_key, [
            'class' => $value['pxl_icon'],
            'aria-hidden' => 'true',
        ] ); ?>
        <div class="pxl--item  <?php if($settings['style'] != 'style-2' || $settings['style'] == 'style7'|| $settings['style'] == 'style5'|| $settings['style'] == 'style3' || $settings['style'] == 'style4') : ?> <?php echo esc_attr($is_active ? 'active' : ''); ?> <?php endif; ?>">
            <?php if($settings['style'] == 'style-2' || $settings['style'] == 'style3'|| $settings['style'] == 'style7' || $settings['style'] == 'style5' || $settings['style'] == 'style4') : ?><div class="wrap-content <?php echo esc_attr($is_active ? 'active' : ''); ?>"><?php endif; ?>
            <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-accordion--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>">
            <?php if ( ! empty( $value['pxl_icon']['value'] ) ) : ?>
                <span class="pxl-title--icon pxl-mr-22">
                    <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </span>
            <?php endif; ?>
            <?php if ( ! empty( $value['link'] ) ) : ?>
                <a <?php echo logiku_render_link_attributes($link); ?>></a>
            <?php endif; ?>
            <?php if ( ! empty( $value['number'] ) ) : ?>
                <span class="pxl-title--number pxl-mr-11">
                    <?php echo wp_kses_post($number); ?>
                </span>
            <?php endif; ?>
            <span class="pxl-title--text pxl-pr-20"><?php echo wp_kses_post($title); ?></span>
            <?php if($settings['style'] == 'style1' || $settings['style'] == 'style6')  : ?><svg class="pxl-icon--plus " xmlns="http://www.w3.org/2000/svg" width="16" height="12" viewBox="0 0 16 12" fill="none">
              <path d="M13.8021 11.0938L8 5.29163L2.19788 11.0938L0 8.89587L8 0.895874L16 8.89587L13.8021 11.0938Z" fill="#FF6F00"/>
              </svg><?php endif; ?> 
                  </<?php pxl_print_html($settings['title_tag']); ?>>
                  <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-accordion--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>>
                    <div class="pxl-accordion--desc">
                        <?php echo wp_kses_post(nl2br($desc)); ?>
                    </div>
                    <div class="pxl-buttom-accordion">
                        <a class="btn-accordion" <?php echo logiku_render_link_attributes($link); ?>>
                            <div class="pxl--btn-text">
                                <?php echo pxl_print_html($btn_text); ?>
                            </div>
                            <div class="pxl--btn-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                                    <path d="M11.8892 2.04687C11.915 1.55049 11.5336 1.12711 11.0373 1.10122L2.94825 0.679366C2.45187 0.653479 2.02848 1.03489 2.0026 1.53127C1.97671 2.02765 2.35812 2.45104 2.8545 2.47692L10.0447 2.85191L9.66975 10.0421C9.64386 10.5385 10.0253 10.9619 10.5217 10.9878C11.018 11.0137 11.4414 10.6323 11.4673 10.1359L11.8892 2.04687ZM1 11L1.60239 11.6687L11.5928 2.66868L10.9904 2L10.388 1.33132L0.397612 10.3313L1 11Z" fill="#FA4729"/>
                                </svg>
                            </div>
                        </a>
                    </div>
                </div>
                <?php if($settings['style'] == 'style-2' || $settings['style'] == 'style5' || $settings['style'] == 'style7' || $settings['style'] == 'style3' || $settings['style'] == 'style4') : ?></div><?php endif; ?>
                <?php if($settings['style'] == 'style-2' || $settings['style'] == 'style5'|| $settings['style'] == 'style7' || $settings['style'] == 'style3' || $settings['style'] == 'style4') : ?>
                    <?php if(!empty($image['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                        ?>
                    <?php } ?>
                    <div class="wrap-image">
                        <?php if ($settings['style'] == 'style5') : ?>
                            <div class="pxl-image">
                            <?php endif; ?>
                            <?php echo wp_kses_post($thumbnail); ?>
                            <?php if ($settings['style'] == 'style5') : ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>