<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <div class="pxl-item-box pxl-item-box2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="item-svg">
            <svg xmlns="http://www.w3.org/2000/svg" width="1402" height="87" viewBox="0 0 1402 87" fill="none">
                <path d="M1 31.5C1 31.5 200.835 0.5 334.785 0.5C483.965 0.5 516.5 86 726 86C935.5 86 973.51 0.5 1118.78 0.5C1237.11 0.5 1401 31.5 1401 31.5" stroke="#FA4729" stroke-opacity="0.37" stroke-dasharray="8 8"/>
            </svg>
        </div>
        <?php foreach ($settings['lists'] as $key => $value):?>
            <div class="item-box-item">
                <div class="pxl-item--inner">
                    <div class="pxl-item--holder">
                        <div class="item-inner">
                            <?php if(!empty($value['pxl_icon'])) {  ?>
                                <div class="pxl-item--icon">
                                    <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                                </div>
                            <?php } ?>
                            <?php if(!empty($value['text'])) : ?>
                                <div class="pxl-item--text">
                                    <?php echo esc_attr($value['text']); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="conten-item">
                            <div class="pxl-item--meta">
                                <h6 class="pxl-item--title el-empty">
                                    <?php if (!empty($value['link']['url'])): ?>
                                        <a href="<?php echo esc_url($value['link']['url']); ?>"<?php echo !empty($value['link']['is_external']) ? 'target="_blank"' : ''; ?><?php echo !empty($value['link']['nofollow']) ? 'rel="nofollow"' : ''; ?>>
                                    <?php endif; ?>
                                        <?php echo esc_attr($value['title']); ?>
                                    <?php if (!empty($value['link']['url'])): ?>
                                        </a>
                                    <?php endif; ?>
                                </h6>
                                <div class="pxl-item--content el-empty"><?php echo pxl_print_html($value['pxl_content']); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>