<?php

$html_id = pxl_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = (int)$widget->get_setting('col_md', '');
if($col_md == 'custom') {
    $col_md = $widget->get_setting('col_md_custom', '');
}
$col_lg = (int)$widget->get_setting('col_lg', '');
if($col_lg == 'custom') {
    $col_lg = $widget->get_setting('col_lg_custom', '');
}
$col_xl = (int)$widget->get_setting('col_xl', '');
if($col_xl == 'custom') {
    $col_xl = $widget->get_setting('col_xl_custom', '');
}
$col_xxl = (int)$widget->get_setting('col_xxl', '');
if($col_xxl == 'custom') {
    $col_xxl = $widget->get_setting('col_xxl_custom', '');
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);
$speed = $widget->get_setting('speed', 500);

$img_size = $widget->get_setting('img_size');
$show_author = $widget->get_setting('show_author');
$show_comment = $widget->get_setting('show_comment');
$show_date = $widget->get_setting('show_date');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_category = $widget->get_setting('show_category');
$num_words = $widget->get_setting('num_words');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_percolumnfill'           => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'            => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-slider pxl-post-carousel pxl-post-carousel1" <?php if($settings['drap'] !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'logiku'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                        $image_size = !empty($img_size) ? $img_size : '427x344';
                        foreach ($posts as $key => $post):
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $author = get_user_by('id', $post->post_author);
                        $current_user = wp_get_current_user();
                        $post_video_link = get_post_meta($post->ID, 'post_video_link', true); ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>">
                                <div class="pxl-item-thumbnail">
                                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                        $img_id = get_post_thumbnail_id($post->ID);
                                        $img          = pxl_get_image_by_size( array(
                                            'attach_id'  => $img_id,
                                            'thumb_size' => $image_size
                                        ) );
                                        $thumbnail    = $img['thumbnail'];
                                        ?>
                                        <div class="pxl-post--featured hover-imge-effect2">
                                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                            <?php if(!empty($post_video_link)) : ?>
                                                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content-holder">
                                    <div class="pxl-post--meta">
                                        <?php if($show_date == 'true'): ?>
                                            <div class="pxl-post--date">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                                    <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                                </svg>
                                                <?php echo get_the_date('j M, Y', $post->ID); ?>        
                                            </div>
                                        <?php endif; ?>
                                        <div class="post-category">
                                            <?php
                                            $categories = get_the_category($post->ID);
                                            if (!empty($categories)) {
                                                foreach ($categories as $category) {
                                                    echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="pxl-post--cat">' . esc_html($category->name) . '</a> ';
                                                }
                                            }
                                            ?>
                                        </div>
                                    </div>
                                    <h3 class="pxl-post--title title-hover-line"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                                    <?php if($show_button == 'true') : ?>
                                        <div class="pxl-post--button">
                                            <a class="btn-post" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                                <div class="btn-text">
                                                    <?php if(!empty($button_text)) {
                                                        echo esc_attr($button_text);
                                                    } else {
                                                        echo esc_html__('Read More', 'logiku');
                                                    } ?>
                                                </div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
                                                    <path d="M11.8892 2.04687C11.915 1.55049 11.5336 1.12711 11.0373 1.10122L2.94825 0.679366C2.45187 0.653479 2.02848 1.03489 2.0026 1.53127C1.97671 2.02765 2.35812 2.45104 2.8545 2.47692L10.0447 2.85191L9.66975 10.0421C9.64386 10.5385 10.0253 10.9619 10.5217 10.9878C11.018 11.0137 11.4414 10.6323 11.4673 10.1359L11.8892 2.04687ZM1 11L1.60239 11.6687L11.5928 2.66868L10.9904 2L10.388 1.33132L0.397612 10.3313L1 11Z" fill="#FA4729"/>
                                                </svg>
                                            </a>
                                            <div class="pxl-admin">
                                                <?php if($show_author == 'true'): ?>
                                                    <div class="pxl-post--author pxl-mr-10">
                                                        <?php echo get_avatar($current_user->ID, 46, '', '', array('class' => 'pxl-mr-7')); ?>
                                                        <?php echo esc_html__('By', 'logiku'); ?>&nbsp; <span>
                                                            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                                                                <?php echo esc_html(get_the_author()); ?>
                                                            </a>
                                                        </span>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div> 
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots-wrap">
                    <div class="pxl-swiper-dots style-1"></div>
                </div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>