<?php
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if(isset($settings['list_content']) && !empty($settings['list_content']) && count($settings['list_content'])): ?>
    <div class="pxl-service5 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['list_content'] as $key => $value):
            $title = isset($value['title']) ? $value['title'] : '';
            $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'list_content', $key );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ] ); ?>
            
            <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                <div class="service-icon">
                    <?php if ( $is_new ):
                        \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                    elseif(!empty($value['pxl_icon'])): ?>
                        <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="service-content">
                <?php if(!empty($title)) : ?>
                    <h3 class="service-title"><?php echo esc_html($title); ?></h3>
                <?php endif; ?>
                <?php if(!empty($sub_title)) : ?>
                    <span class="service-subtitle"><?php echo esc_html($sub_title); ?></span>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
