<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');

$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);

$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '312x499';

if ( ! empty( $settings['wg_btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['wg_btn_link']['url'] );

    if ( $settings['wg_btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['wg_btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<?php if(isset($settings['team']) && !empty($settings['team']) && count($settings['team'])): ?>
    <div class="pxl-grid pxl-team-grid pxl-team-grid2 pxl-team-layout2">
        <div class="pxl-grid-inner pxl-grid-masonry row" data-gutter="15">
            <?php foreach ($settings['team'] as $key => $value):
    			$title = isset($value['title']) ? $value['title'] : '';
                $position = isset($value['position']) ? $value['position'] : '';
                $image = isset($value['image']) ? $value['image'] : '';
                $social = isset($value['social']) ? $value['social'] : '';
                $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
                if ( ! empty( $value['item_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                    if ( $value['item_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['item_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                        <?php if(!empty($image['id'])) { 
                            $img = pxl_get_image_by_size( array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => $image_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail']; ?>
                            <div class="pxl-item--image">
                                <?php if ( ! empty( $value['item_link']['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                    <?php echo wp_kses_post($thumbnail); ?>
                                <?php if ( ! empty( $value['item_link']['url'] ) ) { ?></a><?php } ?>
                                <?php if(!empty($social)): 
                                    $team_social = json_decode($social, true); ?>
                                    <div class="pxl-item--social">
                                        <?php foreach ($team_social as $value): ?>
                                            <a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php } ?>
                        <div class="pxl-item--holder pxl-transition">
                            <div class="pxl-socical-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 35 35" fill="none">
                                    <path d="M26.9899 23.5425C25.3129 23.5425 23.8021 24.2667 22.7535 25.4187L13.3218 19.5772C13.5736 18.9326 13.7132 18.2324 13.7132 17.5C13.7132 16.7672 13.5736 16.0671 13.3218 15.4228L22.7535 9.58097C23.8021 10.7329 25.3129 11.4574 26.9899 11.4574C30.1488 11.4574 32.7187 8.8875 32.7187 5.72856C32.7187 2.56961 30.1488 0 26.9899 0C23.8309 0 21.2611 2.56988 21.2611 5.72882C21.2611 6.46128 21.401 7.16143 21.6525 7.80604L12.2211 13.6475C11.1725 12.4956 9.66162 11.7711 7.98468 11.7711C4.82574 11.7711 2.25586 14.3413 2.25586 17.5C2.25586 20.6589 4.82574 23.2288 7.98468 23.2288C9.66162 23.2288 11.1725 22.5046 12.2211 21.3524L21.6525 27.1939C21.401 27.8385 21.2611 28.5386 21.2611 29.2714C21.2611 32.43 23.8309 34.9999 26.9899 34.9999C30.1488 34.9999 32.7187 32.43 32.7187 29.2714C32.7187 26.1124 30.1488 23.5425 26.9899 23.5425ZM23.35 5.72882C23.35 3.72184 24.9829 2.08896 26.9899 2.08896C28.9969 2.08896 30.6297 3.72184 30.6297 5.72882C30.6297 7.73581 28.9969 9.36869 26.9899 9.36869C24.9829 9.36869 23.35 7.73581 23.35 5.72882ZM7.98468 21.1398C5.97743 21.1398 4.34455 19.5069 4.34455 17.5C4.34455 15.493 5.97743 13.8601 7.98468 13.8601C9.99167 13.8601 11.6243 15.493 11.6243 17.5C11.6243 19.5069 9.99167 21.1398 7.98468 21.1398ZM23.35 29.2711C23.35 27.2641 24.9829 25.6312 26.9899 25.6312C28.9969 25.6312 30.6297 27.2641 30.6297 29.2711C30.6297 31.2781 28.9969 32.911 26.9899 32.911C24.9829 32.911 23.35 31.2781 23.35 29.2711Z" fill="white"/>
                                </svg>
                            </div>
                            <h3 class="pxl-item--title"><?php echo pxl_print_html($title); ?></h3>
                            <div class="pxl-item--position"><span><?php echo pxl_print_html($position); ?></span></div>
                        </div>
                   </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    </div>
<?php endif; ?>
