<?php if(!function_exists('logiku_configs')){
    function logiku_configs($value){
        $primary_darker = logiku()->get_opt('primary_color', '#FA4729');
        $primary_darker_10 = pxl_darker_color($primary_darker, $primary_darker_10=1);
        $primary_darker_20 = pxl_darker_color($primary_darker, $primary_darker_20=1.3);
        $primary_darker_30 = pxl_darker_color($primary_darker, $primary_darker_30=3);
        $primary_darker_40 = pxl_darker_color($primary_darker, $primary_darker_40=4);

        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'logiku'), 
                    'value' => logiku()->get_opt('primary_color', '#FA4729')
                ],
                'gradient-first'   => [
                    'title' => esc_html__('Gradient First', 'logiku'), 
                    'value' => logiku()->get_opt('gradient_first_color', '#ffa800')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'logiku'), 
                    'value' => logiku()->get_opt('secondary_color', '#000000')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'logiku'), 
                    'value' => logiku()->get_opt('third_color', '#00c5fe')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'logiku'), 
                    'value' => logiku()->get_opt('dark_color', '#000')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'logiku'), 
                    'value' => logiku()->get_page_opt('body_bg_color', '#fff')
                ],
                'primary-darker-10'   => [
                    'title' => esc_html__('Primary Darker Color 10', 'logiku'),
                    'value' => $primary_darker_10
                ],
                'primary-darker-20'   => [
                    'title' => esc_html__('Primary Darker Color 20', 'logiku'), 
                    'value' => $primary_darker_20
                ],
                'primary-darker-30'   => [
                    'title' => esc_html__('Primary Darker Color 30', 'logiku'), 
                    'value' => $primary_darker_30
                ],
                'primary-darker-40'   => [
                    'title' => esc_html__('Primary Darker Color 40', 'logiku'), 
                    'value' => $primary_darker_40
                ]
            ],
            'link' => [
                'color' => logiku()->get_opt('link_color', ['regular' => '#16110D'])['regular'],
                'color-hover'   => logiku()->get_opt('link_color', ['hover' => '#FA4729'])['hover'],
                'color-active'  => logiku()->get_opt('link_color', ['active' => '#FA4729'])['active'],
            ],
            'gradient' => [
                'color-from' => logiku()->get_opt('gradient_color', ['from' => '#6000ff'])['from'],
                'color-to' => logiku()->get_opt('gradient_color', ['to' => '#fe0054'])['to'],
            ],
            'gradient2' => [
                'color-from' => logiku()->get_opt('gradient_color2', ['from' => '#8c92f6'])['from'],
                'color-to' => logiku()->get_opt('gradient_color2', ['to' => '#f9d78f'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('logiku_inline_styles')) {
    function logiku_inline_styles() {  
        
        $theme_colors      = logiku_configs('theme_colors');
        $link_color        = logiku_configs('link');
        $gradient_color    = logiku_configs('gradient');
        $gradient_color2   = logiku_configs('gradient2');

        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  logiku_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color2 as $color => $value) {
                printf('--gradient-%1$s2: %2$s;', $color, $value);
            }

        echo '}';

        return ob_get_clean();
         
    }
}
 