<?php
/**
 * @package Case-Themes
 */
$archive_readmore_text = logiku()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'logiku'));
$featured_img_size = logiku()->get_theme_opt('featured_img_size', '960x460');
$post_video_link = get_post_meta(get_the_ID(), 'post_video_link', true);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
<?php if (has_post_thumbnail()) {
        $img  = pxl_get_image_by_size( array(
            'attach_id'  => get_post_thumbnail_id($post->ID),
            'thumb_size' => $featured_img_size,
        ) );
        $thumbnail    = $img['thumbnail'];
        echo '<div class="pxl-item--image">'; ?>
            <a href="<?php echo esc_url( get_permalink()); ?>"><?php echo pxl_print_html($thumbnail); ?></a>
            <?php if(!empty($post_video_link)) : ?>
                <a href="<?php echo esc_url($post_video_link); ?>" class="post-button-video pxl-action-popup"><i class="caseicon-play1"></i></a>
            <?php endif; ?>
        <?php echo '</div>';
    } ?>
    <div class="pxl-item--holder">
        <?php logiku()->blog->get_archive_meta(); ?>
        <h2 class="pxl-item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="caseicon-check-mark pxl-mr-4"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h2>
        <div class="button-standard">
            <div class="pxl-item--readmore">
                <a class="btn btn-text-parallax btn-icon-box" href="<?php echo esc_url( get_permalink()); ?>">
                    <span class="pxl--btn-text"><?php echo logiku_html($archive_readmore_text); ?></span>
                    <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                </a>
            </div>
            <div class="pxl-post--author">
                <?php echo get_avatar(get_the_author_meta('ID'), 46, '', '', array('class' => 'pxl-mr-7')); ?>
                <?php echo esc_html__('By', 'logiku'); ?>&nbsp; <span>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                        <?php echo esc_html(get_the_author()); ?>
                    </a>
                </span>
            </div>
        </div>
    </div>
</article>